! Stores time belonging to the positive zero-crossings in signal1's last period
! of membrane position and velocity in <PositionPhase> and <PositionVelocity>
! Linear interpolation is used to get an exact estimation of the time of the zero-crossing

SUBROUTINE FindPhase
	USE Declare
	USE GraphsModule
	USE ParametersModule, ONLY: plotPhase
	IMPLICIT NONE
	LOGICAL lastPeriod
	
	IF (plotPhase) THEN
		LastPeriod = (t>= t_LastPeriod)
		IF (LastPeriod) THEN
			WHERE (previousPosition < 0 .AND. Y(1:n:plotEvery_n_points) >= 0)
				!Linear interpolation to get the exact time where the position becomes positive
				PositionPhase = t - dt * Y(1:n:plotEvery_n_points) / (Y(1:n:plotEvery_n_points) - previousPosition)
			ENDWHERE
			WHERE (previousVelocity < 0 .AND. V(1:n:plotEvery_n_points) >= 0)
				!Linear interpolation to get the exact time where the velocity becomes positive
				VelocityPhase = t - dt * V(1:n:plotEvery_n_points) / (V(1:n:plotEvery_n_points) - previousVelocity)
			ENDWHERE
			IF (prevStapesPosition < 0 .AND. Y(0) >= 0) THEN
				!Linear interpolation to get the exact time where the position becomes positive
				StapesPositionPhase = t - dt * Y(0) / (Y(0) - prevStapesPosition)
			ENDIF
			IF (prevStapesVelocity < 0 .AND. V(0) >= 0) THEN
				!Linear interpolation to get the exact time where the position becomes positive
				StapesVelocityPhase = t - dt * V(0) / (V(0) - prevStapesVelocity)
			ENDIF
		ENDIF
		previousPosition = Y(1:n:plotEvery_n_points)
		previousVelocity = V(1:n:plotEvery_n_points)
		prevStapesPosition = Y(0)
		prevStapesVelocity = V(0)
	ENDIF
END SUBROUTINE FindPhase